// STACKS1.cpp: implementation of the STACKS class.
//
//////////////////////////////////////////////////////////////////////

#include "STACKS1.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template <class DATATYPE>

STACK<DATATYPE> :: STACK() : data(NULL) , size(0) , maximum_size(0)
{	}

template <class DATATYPE>

STACK<DATATYPE> :: STACK(int num)
{
	data = new DATATYPE[num];
	maximum_size=num;
	size=0;
}

template <class DATATYPE>

void STACK<DATATYPE> :: Push(DATATYPE& value)
{
	if (isFull())
		cerr<<"NOTE : Stack is full"<<endl;
			
	else
		data[++size]=value;
}

template <class DATATYPE>

DATATYPE& STACK<DATATYPE> :: Pop()
{
	if (isEmpty())
		cerr<<"NOTE : Stack is Empty"<<endl;	
	else
		return data[size--];
}

template <class DATATYPE>

DATATYPE& STACK<DATATYPE> :: Peek()
{
	return data[size];
}

template <class DATATYPE>

int STACK<DATATYPE> :: Get_Size()
{
	return size;
}

template <class DATATYPE>

void STACK<DATATYPE> :: ReAllocate(int num)
{
	data = new DATATYPE[num];
	maximum_size=num;
	size=0;	
}

template <class DATATYPE>

bool STACK<DATATYPE> :: isEmpty()
{
	if (size==0)
		return true;

	return false;
}

template <class DATATYPE>

bool STACK<DATATYPE> :: isFull()
{
	if (size==maximum_size)
		return true;

	return false;
}

template <class DATATYPE>

STACK<DATATYPE> :: ~STACK()
{
	if (data!=NULL)
		delete[] data;

	size=0;
}
